@echo off
setlocal
chcp 1252 > nul


rem  sortfolder.bat / Version 1.0 of 2010-06-23 / written by Steffen <muchelchupser[AT]web.de>
rem 
rem  Licensed under Creative Commons 3.0 CC-BY license, see http://creativecommons.org/licenses/by/3.0
rem  Drop me a note if you like this or found a bug.
rem
rem  Recursively sorts a folder and all its contained subfolders and files. Specify that folder as parameter, e.g.
rem
rem     sortfolder M:\mymusic
rem 
rem  Doing this is necessary for some cheap MP3 players which play files in the order they find it in the filesystem
rem  without sorting them before playing, leading to the annoying effect that your MP3s play in wrong order.
rem
rem  The implementation is nearly trivial: the sorting happens by moving everything into a temporary
rem  subfolder, and then moving it back in sorted order. This way, lowlevel filesystem tinkering can be avoided,
rem  especially fiddling with FAT or FAT32 or NTFS specifics. Additional benefit is that the whole thing can be done
rem  by the built-in shell, no need to install a separate program. The script has been developed and tested
rem  on Windows 7 but does not use any specifics of that, so you should as well be able to run it
rem  on Windows XP or Windows 2000. The script is not 32bit or 64bit specific.

rem  This flag controls the sorting order. It's the same flag that the "dir" command takes.
rem  The default value of /oneds will use the file's name, extension, date, size for sorting (in this order).
rem  Additionally, you can restrict the sorting to files of some type by setting e.g. SORTINGORDER=/oneds *.mp3
set  SORTINGORDER=/oneds

if x%1x==xx (
   echo Error: Parameter missing: please specify a folder to sort.
   goto :eof
)
if not x%2x==xx (
   echo Error: Stray second parameter '%2' found. This script only takes one.
   goto :eof
)
pushd %1 >nul 2>&1 || (
   echo Error: Cannot change into folder '%1'. Does it exist? Do you have proper access rights there?
   goto :eof
)
set TEMPFOLDER=zzzzzzzz.tmp
echo Sorting will now run. Please avoid interrupting this - do not press Ctrl+C or close this window.
echo In case you do, nothing too bad will happen, though: a temporary folder named '%TEMPFOLDER%' might remain,
echo containing some of your files. Just manually move them back to their original location one folder up in that case.
for /r . %%f in (.) do (
   echo ...now sorting folder '%%f'
   cd "%%f" || (
      echo Error: Cannot change into folder '%%f'. Do you have proper access rights there?
      goto :eof
   )
   if exist "%TEMPFOLDER%" (
      echo Error: Cannot create temporary folder '%TEMPFOLDER%' in folder '%%f' because a file or folder of that name already exists. Will not clobber that.
      goto :eof
   )
   md "%TEMPFOLDER%" || (
      echo Error: Cannot create temporary folder '%TEMPFOLDER%' in folder '%%f'. Do you have proper write rights there?
      goto :eof
   )
   for /f "usebackq delims==" %%i in (`dir /b %SORTINGORDER%`) do if not "%%i"=="%TEMPFOLDER%" move "%%i" "%TEMPFOLDER%" >nul
   cd "%TEMPFOLDER%"
   for /f "usebackq delims==" %%i in (`dir /b %SORTINGORDER%`) do (
      echo    %%i
      move "%%i" .. >nul
   )
   cd ..
   rd "%TEMPFOLDER%"
)
popd
echo Sorting completed.
